import { world, EquipmentSlot, EntityEquippableComponent, ItemStack, system } from '@minecraft/server';

world.beforeEvents.playerBreakBlock.subscribe(({ block, player }) => {
   try{
      const component = player.getComponent(EntityEquippableComponent.componentId);
      const tool = component.getEquipment(EquipmentSlot.Mainhand);
      if (tool && tool.typeId.includes("_axe") && !player.isSneaking && !player.hasTag("off")) {
         for(let axeBreakableBlocks of AXE_COMMON_BREAKABLE_BLOCKS){
            if (axeBreakableBlocks && axeBreakableBlocks == block.typeId) {
               breakEntireTree(block, player, axeBreakableBlocks);
            }
         }
      }
   }catch(e){}
});

export function breakEntireTree(centerBlock, player, breakableBlocks) {
   const dimension = centerBlock.dimension;
   const blocksToBreak = findConnectedWoodBlocks(centerBlock, breakableBlocks);
   for (const blockLocation of blocksToBreak) {
      const currentBlock = dimension.getBlock(blockLocation);
      if (currentBlock && breakableBlocks.includes(currentBlock.typeId)) {
       dimension.runCommandAsync(`setblock ${blockLocation.x} ${blockLocation.y} ${blockLocation.z} air destroy`);
    }
 }
}

function findConnectedWoodBlocks(startBlock, breakableBlocks, maxDistance = 5) {
   const blocksToCheck = [startBlock.location];
   const checkedBlocks = new Set();
   const connectedBlocks = [];
   while (blocksToCheck.length > 0) {
      const currentLocation = blocksToCheck.pop();
      const locationString = `${currentLocation.x},${currentLocation.y},${currentLocation.z}`;

      if (checkedBlocks.has(locationString)) continue;
      checkedBlocks.add(locationString);

      const currentBlock = startBlock.dimension.getBlock(currentLocation);
      if (currentBlock && breakableBlocks.includes(currentBlock.typeId)) {
         connectedBlocks.push(currentLocation);

         for (let dx = -1; dx <= 1; dx++) {
            for (let dy = -1; dy <= 1; dy++) {
               for (let dz = -1; dz <= 1; dz++) {
                  if (dx === 0 && dy === 0 && dz === 0) continue;

                  const newLocation = {
                     x: currentLocation.x + dx,
                     y: currentLocation.y + dy,
                     z: currentLocation.z + dz
                  };

                  if (Math.abs(newLocation.x - startBlock.location.x) <= maxDistance &&
                     Math.abs(newLocation.y - startBlock.location.y) <= maxDistance+25 &&
                     Math.abs(newLocation.z - startBlock.location.z) <= maxDistance) {
                     blocksToCheck.push(newLocation);
               }
            }
         }
      }
   }
}

return connectedBlocks;
}


system.runInterval(() =>{
  for(let p of world.getPlayers()){
    try{
     let container = p.getComponent(EntityEquippableComponent.componentId);
     let hand = container.getEquipment(EquipmentSlot.Mainhand).typeId;
     if (hand.includes("_axe") && !p.isSneaking && !p.hasTag("noti")){
       p.runCommandAsync("title @s actionbar §7--Sneak + Interact to activate/deactivate--")
       p.addTag("noti")
    }
 }catch(e){
  if(p.hasTag("noti")){
    p.removeTag("noti")
 }
}
}
})

export const AXE_COMMON_BREAKABLE_BLOCKS = [
   'minecraft:stripped_oak_log',
   'minecraft:stripped_dark_oak_log',
   'minecraft:stripped_birch_log',
   'minecraft:stripped_spruce_log',
   'minecraft:stripped_acacia_log',
   'minecraft:stripped_jungle_log',
   'minecraft:stripped_cherry_log',
   'minecraft:stripped_mangrove_log',

   'minecraft:oak_log',
   'minecraft:dark_oak_log',
   'minecraft:birch_log',
   'minecraft:spruce_log',
   'minecraft:acacia_log',
   'minecraft:jungle_log',
   'minecraft:cherry_log',
   'minecraft:mangrove_log',
];


world.afterEvents.itemUse.subscribe(use =>{
 let item = use.itemStack;
 let p = use.source;

 if(item.typeId.includes("_axe") && p.isSneaking && !p.hasTag("off")){
   system.runTimeout(()=>{
    p.runCommandAsync("title @s actionbar §7Tree Capitator: §cOff")
    p.addTag("off")
 }, 2)
}
if(item.typeId.includes("_axe") && p.isSneaking && p.hasTag("off")){
   system.runTimeout(()=>{
    p.runCommandAsync("title @s actionbar §7Tree Capitator: §aOn")
    p.removeTag("off")
 }, 2)
}
})